/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.ILeaveslikeBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.FellDataImpl;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.FellCreditStrategy;
import ht.treechop.common.config.FellLeavesStrategy;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.LevelUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class FellTreeResult
implements ChopResult {
    private final class_1937 level;
    private final FellDataImpl fellData;
    private final Collection<Chop> chops;

    public FellTreeResult(class_1937 level, TreeData tree, boolean breakLeaves, Collection<Chop> chops) {
        this.level = level;
        this.fellData = new FellDataImpl(tree, breakLeaves);
        this.chops = chops;
    }

    @Override
    public void apply(class_2338 targetPos, class_3222 player, class_1799 tool) {
        class_3218 serverLevel;
        class_1934 gameType = player.field_13974.method_14257();
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218 && !(serverLevel = (class_3218)class_19372).method_8320(targetPos).method_26215() && !player.method_21701((class_1937)serverLevel, targetPos, gameType)) {
            boolean fell = TreeChop.platform.startFellTreeEvent(player, this.level, targetPos, this.fellData);
            this.chops.forEach(chop -> chop.apply(this.level, (class_1657)player, tool, fell));
            if (fell) {
                Consumer<class_2338> blockBreaker = FellTreeResult.makeBlockBreaker(player, serverLevel);
                FellTreeResult.breakLogs(player, serverLevel, this.fellData.getTree(), gameType, blockBreaker, targetPos);
                if (this.fellData.getBreakLeaves()) {
                    FellTreeResult.breakLeaves(player, serverLevel, this.fellData.getTree(), gameType, blockBreaker);
                }
                TreeChop.platform.finishFellTreeEvent(player, this.level, targetPos, this.fellData);
            }
        }
    }

    @NotNull
    private static Consumer<class_2338> makeBlockBreaker(class_3222 player, class_3218 level) {
        if (player.method_7337()) {
            class_2680 air = class_2246.field_10124.method_9564();
            return pos -> level.method_8501(pos, air);
        }
        class_3222 creditPlayer = ConfigHandler.COMMON.fellCreditStrategy.get() == FellCreditStrategy.NONE ? null : player;
        class_1799 creditTool = ConfigHandler.COMMON.fellCreditStrategy.get() == FellCreditStrategy.PLAYER_AND_TOOL ? player.method_6047() : class_1799.field_8037;
        return pos -> LevelUtil.harvestBlock((class_1297)creditPlayer, (class_1937)level, pos, creditTool, false);
    }

    private static void breakLogs(class_3222 player, class_3218 level, TreeData tree, class_1934 gameType, Consumer<class_2338> blockBreaker, class_2338 targetPos) {
        long maxNumEffects = 4L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((class_2338)pair.getLeft()).method_10264()));
        tree.streamLogs().filter(pos -> !pos.equals((Object)targetPos) && !player.method_21701((class_1937)level, targetPos, gameType)).forEach(pos -> {
            FellTreeResult.collectSomeBlocks(effects, pos, level.method_8320(pos), i, 3);
            blockBreaker.accept((class_2338)pos);
        });
        effects.stream().limit(4L).forEach(posState -> FellTreeResult.playBlockBreakEffects((class_1937)level, (class_2338)posState.getLeft(), (class_2680)posState.getRight()));
    }

    private static void breakLeaves(class_3222 player, class_3218 level, TreeData tree, class_1934 gameType, Consumer<class_2338> blockBreaker) {
        long maxNumEffects = 5L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((class_2338)pair.getLeft()).method_10264()));
        boolean tryToDecay = ConfigHandler.COMMON.fellLeavesStrategy.get() == FellLeavesStrategy.DECAY;
        Consumer<class_2338> leavesBreaker = pos -> {
            if (!player.method_21701((class_1937)level, pos, gameType)) {
                class_2680 state = level.method_8320(pos);
                ILeaveslikeBlock leavesLike = ClassUtil.getLeaveslikeBlock(state.method_26204());
                if (leavesLike != null) {
                    leavesLike.fell((class_1657)player, (class_1937)level, (class_2338)pos, state);
                } else if (tryToDecay && FellTreeResult.shouldDecayLeaves(state)) {
                    FellTreeResult.decayLeavesInsteadOfBreaking(level, pos, state);
                } else {
                    blockBreaker.accept((class_2338)pos);
                }
                if (effects.isEmpty() || player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 9.0) {
                    FellTreeResult.collectSomeBlocks(effects, pos, state, i, 8);
                }
            }
        };
        tree.forEachLeaves(leavesBreaker);
        effects.stream().limit(5L).forEach(posState -> FellTreeResult.playBlockBreakEffects((class_1937)level, (class_2338)posState.getLeft(), (class_2680)posState.getRight()));
    }

    private static void collectSomeBlocks(Queue<Pair<class_2338, class_2680>> collection, class_2338 pos, class_2680 state, AtomicInteger counter, int period) {
        if (counter.getAndIncrement() % period == 0) {
            collection.add((Pair<class_2338, class_2680>)Pair.of((Object)pos, (Object)state));
        }
    }

    private static void playBlockBreakEffects(class_1937 level, class_2338 pos, class_2680 state) {
        level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
    }

    private static void decayLeavesInsteadOfBreaking(class_3218 level, class_2338 pos, class_2680 state) {
        class_2680 decayingState = (class_2680)((class_2680)state.method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(7));
        decayingState.method_26199(level, pos, level.field_9229);
    }

    private static boolean shouldDecayLeaves(class_2680 blockState) {
        return blockState.method_28498((class_2769)class_2397.field_11199) && blockState.method_28498((class_2769)class_2397.field_11200) && ((class_2680)((class_2680)blockState.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(7))).method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(false))).method_26229();
    }
}

